// SClawHub Popup Script

const API_BASE = 'https://sclawhub.com';

async function getCurrentTab() {
  const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });
  return tab;
}

function extractSkillSlug(url) {
  const match = url.match(/\/skills\/([^\/\?#]+)/);
  return match ? match[1] : null;
}

async function loadStats() {
  try {
    const response = await fetch(`${API_BASE}/api/stats`);
    if (response.ok) {
      const stats = await response.json();
      document.getElementById('skills-scanned').textContent = stats.total || '10+';
      document.getElementById('avg-score').textContent = stats.avgScore ? `${stats.avgScore}/100` : '85/100';
    }
  } catch (error) {
    console.error('Failed to load stats:', error);
  }
}

async function init() {
  const tab = await getCurrentTab();
  
  // Check if we're on ClawHub
  if (tab.url.includes('clawhub.com')) {
    const slug = extractSkillSlug(tab.url);
    
    if (slug) {
      // We're on a skill page
      document.getElementById('current-page').style.display = 'block';
      document.getElementById('page-url').textContent = 'ClawHub Skill Page';
      
      // Show convert button
      const convertBtn = document.getElementById('convert-url');
      convertBtn.style.display = 'block';
      convertBtn.addEventListener('click', () => {
        const secureUrl = tab.url.replace('clawhub.com', 'sclawhub.com');
        chrome.tabs.create({ url: secureUrl });
      });
      
      // Show scan button
      const scanBtn = document.getElementById('scan-current');
      scanBtn.style.display = 'block';
      scanBtn.addEventListener('click', () => {
        chrome.tabs.create({ url: `${API_BASE}/scan` });
      });
    }
  }
  
  // Browse skills button
  document.getElementById('browse-skills').addEventListener('click', () => {
    chrome.tabs.create({ url: `${API_BASE}/skills` });
  });
  
  // Load stats
  loadStats();
}

// Initialize on popup open
init();
