#!/bin/bash
# Create placeholder icons using ImageMagick (if available)
# Or use base64 data URLs as fallback

if command -v convert &> /dev/null; then
    # Create with ImageMagick
    convert -size 128x128 xc:'#2563eb' -fill white -pointsize 80 -gravity center -annotate +0+0 '🦞' icon128.png
    convert -size 48x48 xc:'#2563eb' -fill white -pointsize 30 -gravity center -annotate +0+0 '🦞' icon48.png  
    convert -size 16x16 xc:'#2563eb' -fill white -pointsize 10 -gravity center -annotate +0+0 'S' icon16.png
    echo "✅ Icons created with ImageMagick"
else
    echo "⚠️  ImageMagick not found"
    echo "Please create icons manually or install ImageMagick:"
    echo "  brew install imagemagick"
    echo ""
    echo "Alternatively, use any image editing tool to create:"
    echo "  - icon16.png (16x16)"
    echo "  - icon48.png (48x48)"  
    echo "  - icon128.png (128x128)"
fi
