# Extension Icons

## Required Icons

Create these icons for the browser extension:

- `icon16.png` - 16x16px (browser toolbar)
- `icon48.png` - 48x48px (extension management page)
- `icon128.png` - 128x128px (Chrome Web Store)

## Design Guidelines

**Theme**: Lobster 🦞 + Shield 🛡️

**Colors**:
- Primary: #2563eb (blue)
- Accent: #10b981 (green for security)
- Background: #0f172a (dark slate)

**Concepts**:

1. **Simple**: Just the 🦞🛡️ emoji combo
2. **Logo**: Lobster claw holding a shield
3. **Badge**: Shield with "S" letter inside
4. **Modern**: Gradient blue shield with lobster silhouette

## Quick Creation (Using Figma/Canva)

1. Create 512x512px artboard
2. Add lobster + shield emoji or icons
3. Export at 128x128px (will auto-generate smaller sizes)
4. Resize to 48x48px and 16x16px

## Temporary Solution

Use emoji as base64 or create simple colored squares:

```bash
# Generate placeholder icons (macOS)
# This creates simple colored squares as placeholders

convert -size 128x128 xc:#2563eb -pointsize 80 -fill white \
  -annotate +20+90 "🦞" icon128.png

convert -size 48x48 xc:#2563eb -pointsize 30 -fill white \
  -annotate +8+35 "🦞" icon48.png

convert -size 16x16 xc:#2563eb -pointsize 12 -fill white \
  -annotate +2+13 "S" icon16.png
```

For now, you can also just use any placeholder images and update them later before Chrome Web Store submission.
