// SClawHub Background Service Worker

chrome.runtime.onInstalled.addListener(() => {
  console.log('🦞🛡️ SClawHub extension installed');
});

// Listen for tab updates to detect ClawHub pages
chrome.tabs.onUpdated.addListener((tabId, changeInfo, tab) => {
  if (changeInfo.status === 'complete' && tab.url?.includes('clawhub.com')) {
    // Update badge to show we're active on this page
    chrome.action.setBadgeText({ text: '✓', tabId });
    chrome.action.setBadgeBackgroundColor({ color: '#2563eb', tabId });
  }
});
